package com.berrystore.sockets;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface SocketWrapper {
	
	public static final int TRANSPORT_PLAIN = 1;
	public static final int TRANSPORT_SSL = 2;

	public void connect(int protocol, String host, int port) throws IOException;
	
	public InputStream getInputStream() throws IOException;
	public OutputStream getOutputStream() throws IOException;
	
	public int getSoLinger() throws IOException;
	public void setSoLinger(boolean on, int linger) throws IOException;
	
	public boolean getTcpNoDelay() throws IOException;
	public void setTcpNoDelay(boolean on) throws IOException;
	
	public int getSoTimeout() throws IOException;
	public void setSoTimeout(int timeout) throws IOException;
	
	public void close() throws IOException;
	
	public boolean isOpen();
}
